IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.[CP_Ingresos_por_Tvalor]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CP_Ingresos_por_Tvalor]
END
GO
CREATE PROCEDURE [dbo].[CP_Ingresos_por_Tvalor]
	@pFecha_Desde			DATETIME,
	@pFecha_Hasta			DATETIME, 
	@pId_Tipo_cbte          Char(4),
	@pId_Tipo_Val           VARCHAR(3),
	@pTipo                  Char(1),
	@pId_Tarjeta            Char(10),
	@pId_Periodo_Caja       INT

AS

SET NOCOUNT ON
DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Descripcion	    CHAR(50)
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Tipo_Val   	CHAR(3)
		,@CursorOpen        INT
		,@Tipo	            char(1)
		,@Periodo           DATE 
		,@Id_sucursal	    SMALLINT
		,@Existe      	    SMALLINT
		,@Id_tarjeta        CHAR(10)
		,@Id_Tipo_cbte      CHAR(4)

CREATE TABLE #VTAS_FPAGO (
        Id_Tarjeta CHAR(10),
		Descripcion  Char(50),
        Importe	decimal(16,2)
		)
		
SELECT * INTO #CAJAS FROM Cajas_Periodos
	IF @pId_Periodo_Caja  <> 0
	   DELETE #CAJAS WHERE Id_Periodo_Caja <> @pId_Periodo_Caja    

  IF @pId_Tipo_cbte <> ''
		   BEGIN
	            DECLARE TagCbtesCursor CURSOR FOR 
				select v.id_tipo_val,tc.tipo,TC.Id_Tarjeta,TC.Descripcion ,sum(ISNULL(v.importe,0) * V.COTIZACION) as importe
				from cbtes c, valores v LEFT OUTER JOIN Valores_Tarjetas_Cred tc on v.id_tarjeta = tc.id_tarjeta 
				,valores_mov m, cbtes_tipos t, #CAJAS CA
				where c.id_trans = m.id_trans 
				and m.id_valor = v.id_valor 
				AND V.Id_Periodo_Caja = CA.Id_Periodo_Caja
				and c.id_tipo_cbte = t.id_tipo_cbte
				AND C.FECHA >= @pFecha_Desde 
				AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)
				and v.id_tipo_val = @pId_Tipo_Val
				and c.Id_Estado_Cbte not in (0,3)
				and t.id_tipo_cbte = @pid_tipo_cbte
				group by v.id_tipo_val,tc.tipo,TC.Id_Tarjeta,TC.Descripcion HAVING SUM(v.importe  * V.COTIZACION) <> 0
            END
		  ELSE
		    BEGIN
		     	DECLARE TagCbtesCursor CURSOR FOR 
				select v.id_tipo_val,tc.tipo,TC.Id_Tarjeta,TC.Descripcion ,sum(ISNULL(v.importe,0) * V.COTIZACION) as importe
				from cbtes c, valores v LEFT OUTER JOIN Valores_Tarjetas_Cred tc on v.id_tarjeta = tc.id_tarjeta 
				,valores_mov m, cbtes_tipos t, #CAJAS CA 
				where c.id_trans = m.id_trans 
				and m.id_valor = v.id_valor 
				AND V.Id_Periodo_Caja = CA.Id_Periodo_Caja
				and c.id_tipo_cbte = t.id_tipo_cbte
				AND C.FECHA >= @pFecha_Desde 
				AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)
				and v.id_tipo_val = @pId_Tipo_Val
				and c.Id_Estado_Cbte not in (0,3)
				and (t.Compromete_Recibos in (1,-1)
				     or (t.Compromete_Factura in (1,-1) and c.Id_Cond_Pago = 1))
				group by v.id_tipo_val,tc.tipo,TC.Id_Tarjeta,TC.Descripcion HAVING SUM(ISNULL(v.importe,0) * V.COTIZACION) <> 0		    
            END

		OPEN TagCbtesCursor

		FETCH NEXT FROM TagCbtesCursor INTO @id_tipo_val,@tipo,@Id_Tarjeta,@Descripcion,@Importe 
		SET @CursorOpen = 0	
		SET @UltError = 0
		WHILE @@FETCH_STATUS=0 AND @UltError  = 0
		BEGIN
            SET @Existe = (Select ISNULL(Count(*),0) from #VTAS_FPAGO where Id_Tarjeta = @Id_Tarjeta)
			
			IF @Existe = 0
			   INSERT INTO #VTAS_FPAGO (
			            Id_Tarjeta,
						Descripcion,
						Importe	
						)
				VALUES (
				@id_Tarjeta,
                @Descripcion,
				0
				)

			IF @id_tipo_val = 'EFE'                     UPDATE #VTAS_FPAGO SET  Importe = Importe + @Importe WHERE  Id_Tarjeta = @Id_Tarjeta
			IF @id_tipo_val = 'TAR' AND @TIPO = @pTipo  UPDATE #VTAS_FPAGO SET  Importe = Importe + @Importe WHERE  Id_Tarjeta = @Id_Tarjeta
			IF @id_tipo_val = 'FIN'                     UPDATE #VTAS_FPAGO SET  Importe = Importe + @Importe WHERE  Id_Tarjeta = @Id_Tarjeta  


   		FETCH NEXT FROM TagCbtesCursor INTO  @id_tipo_val,@tipo,@Id_Tarjeta,@Descripcion,@Importe 

		END
		CLOSE TagCbtesCursor
		DEALLOCATE TagCbtesCursor
   
    SELECT * FROM #VTAS_FPAGO WHERE IMPORTE <> 0 ORDER BY 1

    DROP TABLE #VTAS_FPAGO
    DROP TABLE #CAJAS

  -- CP_INGRESOS_por_Tvalor '20220201','20220201','REC1','TAR','D','0',0



 
 
